unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ActnList, StdCtrls, ExtActns, XPMan, ComCtrls, Spin;

type TDownload = class(TThread)
  protected
    procedure Execute; override;
end;

type
  TfrmMain = class(TForm)
    Edit: TEdit;
    btnAdd: TButton;
    ListBox: TListBox;
    btnStart: TButton;
    ActionList: TActionList;
    btnDelete: TButton;
    FileRun: TFileRun;
    XPManifest: TXPManifest;
    StatusBar: TStatusBar;
    Label1: TLabel;
    Label2: TLabel;
    seTo: TSpinEdit;
    seFrom: TSpinEdit;
    Label3: TLabel;
    ProgressBar: TProgressBar;
    procedure btnAddClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;
  Download: TDownload;

implementation

{$R *.dfm}

procedure TfrmMain.btnAddClick(Sender: TObject);
begin
  ListBox.Items.Add(Edit.Text);
  Edit.Text := '';
end;

procedure TfrmMain.btnDeleteClick(Sender: TObject);
begin
  ListBox.Items.Delete(ListBox.ItemIndex);
end;

procedure TfrmMain.btnStartClick(Sender: TObject);
begin
  if btnStart.Caption = 'Start' then
   begin
    btnStart.Caption := 'Stop';
    Download := TDownload.Create(false);
    Download.FreeOnTerminate := true;
    btnStart.Enabled := false;
   end
  else
   begin
    Download.Terminate;
    btnStart.Caption := 'Start';
   end;
end;



procedure TDownload.Execute;
var
  count, i, j, from, hmm: Integer;
  verze, p, d, t, zadani, reseni: String;
begin
  count := frmMain.ListBox.Count;
  from := frmMain.seFrom.Value;
  hmm := frmMain.seTo.Value;

  frmMain.FileRun.FileName := 'wget';
  frmMain.ProgressBar.Max := count*(hmm-from);

  for i := 0 to count-1 do
   begin
    verze := frmMain.ListBox.Items.Strings[i];
    p := verze[1];
    d := verze[2];
    t := verze[3];
    for j := from to hmm do
     begin
      zadani := '-P ' + verze + '/zadani http://trial.kma.zcu.cz/Tdb/' + p + '/' + d + '/' + t + '/Tzadani_' + IntToStr(j) + '.gif';
      frmMain.FileRun.Parameters := zadani;

      frmMain.StatusBar.SimpleText := 'Stahuji zadani ' + verze + '/' + IntToStr(j);
      frmMain.FileRun.Execute;
      Sleep(500);

      reseni := '-P ' + verze + '/reseni http://trial.kma.zcu.cz/Tdb/' + p + '/' + d + '/' + t + '/Treseni_' + IntToStr(j) + '.gif';
      frmMain.FileRun.Parameters := reseni;

      frmMain.StatusBar.SimpleText := 'Stahuji reseni ' + verze + '/' + IntToStr(j);
      frmMain.FileRun.Execute;
      Sleep(500);

      frmMain.ProgressBar.StepBy(1);
     end;
   end;
  frmMain.StatusBar.SimpleText := 'Nyn pokejte ne dobhnou vechny thready!';
  frmMain.btnStart.Caption := 'Start';
  frmMain.btnStart.Enabled := true;
end;

end.
